
TYPE
	ASYNC_MOVE_16_enum : 
		(
		ASYNC16_WAIT := 1,
		ASYNC16_CHECK_TARGET_POS := 5,
		ASYNC16_SORT_X_POS := 10,
		ASYNC16_SORT_Y_POS := 11,
		ASYNC16_FIND_LIMIT := 15,
		ASYNC16_FIND_INIT_POS_0 := 16,
		ASYNC16_FIND_INIT_POS_1 := 17,
		ASYNC16_COUNT_MISPLACED_SHUTTLES := 20,
		ASYNC16_SWAP_SHUTTLES := 25,
		ASYNC16_MOVE_INIT_POS := 30,
		ASYNC16_MOVE_TARGET_POS := 35,
		ASYNC16_SHUFFLE := 36,
		ASYNC16_DONE := 40,
		ASYNC16_ERROR := 99
		);
	CmdErrorType : 	STRUCT 
		CMDErrorID : UINT;
		CmdID : UINT;
	END_STRUCT;
	COMMAND_STATE_MACHINE : 
		(
		SEND_COMMAND,
		WAIT_FOR_REPLY,
		READ_REPLY
		);
	ERROR_STATE_ENUM : 
		(
		PM_ERR_INVALID_PARAMETERS := 16384,
		PM_ERR_WRONG_XBOTSTATE := 12288,
		PM_ERR_WRONG_MACROSTATE := 8196
		);
	FileIOErrorIDtype : 	STRUCT 
		FileIOSysErrorID : UINT;
		FileIOErrorID : UINT;
	END_STRUCT;
	InfoType : 	STRUCT 
		FileIOErrorInfo : FileIOErrorIDtype;
		SyntaxErrorInfo : SyntaxErrorType;
		CmdErrorInfo : CmdErrorType;
		CmdError : BOOL;
		FileIOError : BOOL;
		SyntaxError : BOOL;
		XmlError : BOOL;
		XmlErrorInfo : XmlErrorInfoType;
	END_STRUCT;
	LinMove : 	STRUCT 
		Type : USINT;
		XTarget : REAL;
		YTarget : REAL;
		FinalSpeed : REAL;
		MaxAcc : REAL;
		MaxSpeed : REAL;
		XbotID : USINT;
		CmdID : USINT;
		CmdType : USINT;
	END_STRUCT;
	msgPtr : 	STRUCT 
		msgFrame : ARRAY[0..399]OF USINT;
		readFrame : ARRAY[0..399]OF USINT;
	END_STRUCT;
	PMShuffle_enum : 
		(
		SHUFFLE_WAIT := 0,
		SHUFFLE_GET_RANDOM_PARAM := 1,
		SHUFFLE_MOVE := 3,
		SHUFFLE_STOP := 4,
		SHUFFLE_ASSIGN_RANDOM_PARAM := 2,
		SHUFFLE_ERROR := 6,
		SHUFFLE_DONE := 5
		);
	PMTargetPositionType : 	STRUCT 
		X : REAL; (*Target X position [mm]*)
		Y : REAL; (*Target Y position [mm]*)
		Z : REAL; (*Target Z position [mm]*)
		RX : REAL; (*Target RX position [mm]*)
		RY : REAL; (*Target RY position [mm]*)
		RZ : REAL; (*Target RZ position [mm]*)
		PositionMode : USINT; (*0 = Absolute positioning, 1 = Relative*)
		PathType : USINT; (*0 = X and Y, 1 = First X then Y, 2 = First Y then X*)
		FinalSpeed : REAL; (*Final speed [m/s]*)
		MaxAccel : REAL; (*Maximum Acceleration [m/s2]*)
		MaxSpeed : REAL; (*Maximum speed [m/s]*)
		Angle : REAL; (*ArcMode = 0: Radius = radius [m], ArcMode = 1, Radius = Angle(rad)*)
		Direction : USINT; (*0 = Clockwise, 1 = Counter clockwise*)
		ArcMode : USINT; (*0 = Target position and arc radius mode, 1 = Arc center and rotation angle (|rad|) mode*)
		MacroID : USINT; (*Macro ID,  ID between 128 to 255*)
		MacroOption : USINT; (*0 = Clear motion commands in Macro, 2= End editing and save Macro, 4 = Query macro status *)
		ArcType : USINT; (*0 = Minor Arc (shortest path arc) 1 = Major arc (longest arc path)*)
		XAsyncTarget : ARRAY[0..ASYNC_MAX_XBOT]OF REAL;
		YAsyncTarget : ARRAY[0..ASYNC_MAX_XBOT]OF REAL;
		XbotIDAsync : ARRAY[0..ASYNC_MAX_XBOT]OF USINT;
		NumOfXbot : USINT;
		BufferOption : USINT;
		Type : STRING[80];
		CmdLabel : UINT;
		XbotID : USINT;
		CmdID : UINT;
	END_STRUCT;
	PMWaitUntilType : 	STRUCT 
		WaitMode : USINT; (*0 = Time Delay mode, 1 = External Digital input mode, 2 = Fieldbus digital input mode, 3 = Command label mode, 4 = displacement mode*)
		PosFactorA : REAL; (*Position Factor A in AX+BY. Ignored by PMC if WaitMode <> 2 or 4*)
		PosFactorB : REAL; (*Position Factor B in AX+BY. Ignored by PMC if WaitMode <> 2 or 4*)
		DisplacementTrigger : REAL; (*Displacement trigger treshold [mm], ignored by PMC if WaitMode <> 4*)
		DigitalID : USINT; (*WaitMode = 1, DigitalID = ChannelID, WaitMode = 2 DigitalID = Fieldbus Digital Input ID *)
		TriggerCmdLabel : UINT; (*Trigger command label*)
		TriggerMode : USINT; (*0 = X Only, 1 = Y Only, 2 = AX+BY*)
		TimeDelay : REAL; (*WaitMode = 0, Time delay [ms]*)
		TriggerType : USINT; (*WaitMode = 1,2  {0 = Rising Edge, 1 = Falling Edge, 2 = Equal to 1, 3 = Equal to 0}, WaitMode = 3 {0 = Staring Execution, 1= Finishing Execution, 2 0 During execution}, WaitMode = 4 { 0 = > threshold, 1 = < threhold, 2 = Rising above threshold, 3 = Falling below threshold}*)
		TriggerXbotID : USINT; (*XbotID for trigger*)
	END_STRUCT;
	POSITION_MODE : 
		(
		ABSOLUTE := 0,
		RELATIVE := 1
		);
	READ_XML_DIRECTORY : 
		(
		DIR_WAIT := 0,
		DIR_INFO := 1,
		DIR_OPEN := 2,
		DIR_CREATE := 3,
		DIR_CLOSE := 4,
		DIR_READ := 5,
		DIR_DONE := 6,
		DIR_ERROR := 99
		);
	StatusType : 	STRUCT  (*Status for Xbot and PMC*)
		PMC : USINT; (*PMC Status*)
		Xbot : ARRAY[0..MAX_XBOT]OF USINT; (*Xbot status*)
	END_STRUCT;
	SyntaxErrorType : 	STRUCT 
		CmdID : UINT;
		Param : STRING[80];
	END_STRUCT;
	XmlErrorInfoType : 	STRUCT 
		XmlErrorID : UINT;
	END_STRUCT;
	XML_READ_STATE_ENUM : 
		(
		XML_WAIT,
		XML_FILE_OPEN,
		XML_FILE_READ,
		XML_CREATE_MEMORY_READ,
		XML_READ_ATTRIBUTE,
		XML_READ_PARAMETER,
		XML_READ_COMMAND,
		XML_READ_COMMAND_ID,
		XML_STOP_READ,
		XML_FILE_CLOSE,
		XML_MOVE_CMD,
		XML_EDIT_MACRO,
		XML_RUN_MACRO,
		XML_LINEAR_MOTION,
		XML_ARC_MOTION,
		XML_WAIT_UNTIL,
		XML_SHORT_AXIS_MOTION,
		XML_READ_INIT,
		XML_DONE,
		XML_ERROR := 99
		);
	Async16SideType : 	STRUCT 
		XbotList : ARRAY[0..7]OF UINT;
		NumOfLostXbot : USINT; (*Number of Xbot on the other side*)
		InPosition : BOOL;
		NumOfXbot : USINT;
		XInit : ARRAY[0..7]OF REAL;
		YInit : ARRAY[0..7]OF REAL;
		InitID : ARRAY[0..7]OF USINT;
	END_STRUCT;
END_TYPE
